/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extras.core.bamboo;

import com.atlassian.extras.api.LicenseEdition;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.bamboo.BambooLicense;
import com.atlassian.extras.common.LicenseTypeAndEditionResolver;
import com.atlassian.extras.common.util.LicenseProperties;
import com.atlassian.extras.core.DefaultProductLicense;

class DefaultBambooLicense
extends DefaultProductLicense
implements BambooLicense {
    private final int maximumNumberOfAgents;
    private final LicenseEdition licenseEdition;

    DefaultBambooLicense(Product product, LicenseProperties licenseProperties) {
        super(product, licenseProperties);
        int maxAgents = licenseProperties.getInt("NumberOfBambooAgents", 0);
        this.maximumNumberOfAgents = maxAgents != -1 ? maxAgents : Integer.MAX_VALUE;
        this.licenseEdition = LicenseTypeAndEditionResolver.getLicenseEdition(licenseProperties.getProperty("LicenseEdition"));
    }

    public LicenseEdition getLicenseEdition() {
        return this.licenseEdition;
    }

    public int getMaximumNumberOfRemoteAgents() {
        return this.maximumNumberOfAgents;
    }
}

