/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extension.base;

import com.atlassian.extension.api.ExtensionAccessor;
import com.atlassian.extension.provider.api.ExtensionProvider;
import com.atlassian.extension.provider.api.ExtensionTag;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class CachingExtensionAccessor
implements ExtensionAccessor {
    private final List<ExtensionProvider> extensionProviders;

    public CachingExtensionAccessor(Iterable<ExtensionProvider> extensionProviders) {
        this.extensionProviders = ImmutableList.copyOf(extensionProviders);
    }

    @Nonnull
    public <E> Iterable<E> getExtensionsByClass(Class<E> extensionClass) {
        Function<Iterable, Iterable> identityTransform = extensions -> extensions;
        Function<Iterable, Iterable> concatenatingReduction = Iterables::concat;
        return this.getExtensionsByClassSupplier(extensionClass, identityTransform, concatenatingReduction).get();
    }

    @Nonnull
    public <E, D> Supplier<D> getExtensionsByClassSupplier(Class<E> extensionClass, Function<Iterable<E>, D> extensionTransform, Function<Iterable<D>, D> extensionReduce) {
        HashMap cache = new HashMap();
        Predicate<ExtensionTag> cached = cache::containsKey;
        return () -> {
            ImmutableList.Builder intermediates = ImmutableList.builder();
            for (ExtensionProvider extensionProvider : this.extensionProviders) {
                ExtensionTag.Tagged taggedExtensionsByClass = extensionProvider.getExtensionsByClass(extensionClass, cached);
                if (!taggedExtensionsByClass.isTagged()) {
                    intermediates.add(extensionTransform.apply((Iterable)taggedExtensionsByClass.getContent()));
                    continue;
                }
                ExtensionTag extensionTag = taggedExtensionsByClass.getTag();
                Object cachedIntermediate = cache.get(extensionTag);
                if (null != cachedIntermediate) {
                    intermediates.add(cachedIntermediate);
                    continue;
                }
                Object intermediate = extensionTransform.apply((Iterable)taggedExtensionsByClass.getContent());
                cache.put(extensionTag, intermediate);
                intermediates.add(intermediate);
            }
            return extensionReduce.apply((Iterable)intermediates.build());
        };
    }
}

