package com.atlassian.dragonfly.api;

import com.atlassian.applinks.api.ApplicationLink;

import java.net.URI;

public interface CrowdIntegrationConfigurator
{
    /**
     * Configures the application to use Crowd as its authentication mechanism.
     *
     * Steps involves:-
     * - Creates a new application in remote embedded crowd
     * - Switches the authentication mechanism of the application to crowd authentication
     *
     * @param jiraUrl url of the remote jira instance
     * @param username jira admin username
     * @param password jira admin password
     *
     * @throws JiraIntegrationConfigurationException if anything went wrong, also in which case all the applied configurations will be rolled back
     * @return the representation of the application created
     */
    CrowdApplicationEntity configureCrowdAuthentication(URI jiraUrl, String username, String password) throws JiraIntegrationConfigurationException;

    /**
     * Rolls back the configured crowd authentication.
     * This can be called only after {@link #configureCrowdAuthentication(java.net.URI, String, String)} has already been called once.
     *
     */
    public void rollbackCrowdAuthenticationConfiguration();
}
