package com.atlassian.dragonfly.api;

/**
 * Used to indicate something has gone wrong during the configuration process.
 */
public class JiraIntegrationConfigurationException extends Exception
{
    /**
     * @param prettyUserMessage a message for display in the UI that will contain a brief description of the problem
     * and the next steps the user should take.
     */
    public JiraIntegrationConfigurationException(final String prettyUserMessage)
    {
        super(prettyUserMessage);
    }

    /**
     * @param prettyUserMessage a message for display in the UI that will contain a brief description of the problem
     * and the next steps the user should take.
     * @param cause the nested exception that is or contains the root cause of the problem
     */
    public JiraIntegrationConfigurationException(final String prettyUserMessage, final Throwable cause)
    {
        super(prettyUserMessage, cause);
    }
}

