package com.atlassian.dragonfly.api;

import java.net.URI;

public interface JiraAccessUtil
{
    /**
     * Checks whether the given URL is Jira 4.3+.
     *
     * @param remoteUrl remote URL
     * @return if the target Jira is supported
     */
    boolean checkTargetIsSupportedJira(URI remoteUrl);

    /**
     * Checks whether the given credential represents an admin in the given URL.
     *
     * @param remoteUrl remote URL
     * @param username supposedly admin username
     * @param password supposedly admin password
     * @return if the credential represents an admin
     */
    boolean checkAdminCredential(URI remoteUrl, String username, String password);
}
