package com.atlassian.diagnostics.internal.platform.monitor.http;

import javax.annotation.Nonnull;
import java.time.Duration;

class HttpRequestDiagnostic {

    private final String requestPath;
    private final Duration requestDuration;
    private final String username;

    HttpRequestDiagnostic(@Nonnull final String requestPath,
                          @Nonnull final String username,
                          @Nonnull final Duration requestDuration) {
        this.requestPath = requestPath;
        this.username = username;
        this.requestDuration = requestDuration;
    }

    String getRequestPath() {
        return requestPath;
    }

    String getUsername() {
        return username;
    }

    Duration getRequestDuration() {
        return requestDuration;
    }

}
