package com.atlassian.diagnostics.internal.platform.monitor.db;

import com.atlassian.diagnostics.MonitorConfiguration;
import com.atlassian.diagnostics.internal.platform.poller.ScheduleInterval;

import javax.annotation.Nonnull;
import java.time.Duration;

public interface DatabaseMonitorConfiguration extends MonitorConfiguration {
    /**
     * A cross-product property key to use for {@link DatabaseMonitorConfiguration#findStaticMethodInvoker()}
     */
    String DB_STATIC_METHOD_INVOKER_ENABLE = "com.atlassian.diagnostics.db.static.method.invoker.enable";

    /**
     * A cross-product property key to use for {@link DatabaseMonitorConfiguration#staticMethodInvokerImprovedAccuracy()}
     */
    String DB_STATIC_METHOD_INVOKER_IMPROVED_ACCURACY_ENABLE =
            "atlassian.diagnostics.db.static.method.invoker.improved.accuracy.enable";

    /**
     * @return the connection pool abandonment timeout
     */
    @Nonnull
    Duration poolConnectionLeakTimeout();

    /**
     * @return the percentage limit for pool utilization
     */
    double poolUtilizationPercentageLimit();

    /**
     * @return the time duration to wait before raising a high pool utilization alert
     */
    @Nonnull
    Duration poolUtilizationTimeWindow();

    /**
     * @return the limit in millis-seconds for long-running database queries
     */
    @Nonnull
    Duration longRunningOperationLimit();

    /**
     * @return configured setting for displaying the SQL query in the alert or an empty string
     */
    boolean includeSqlQueryInAlerts();

    @Nonnull
    ScheduleInterval databasePoolPollerScheduleInterval();

    /**
     * @return whether {@link DatabaseMonitor}s should find plugins utilising the DB through static method invocation.
     */
    boolean findStaticMethodInvoker();

    /**
     * It's possible that some plugins may not be found normally. With this enabled, more expensive plugin finding
     * solutions will be used that are more likely to correctly find the invoking plugin.
     * <p>
     * <b>NOTE:</b> This may come with a performance penalty during heavy DB usage.
     *
     * @return whether {@link DatabaseMonitor}s should use a method with improved accuracy for finding plugins.
     */
    boolean staticMethodInvokerImprovedAccuracy();
}
