package com.atlassian.diagnostics.internal.platform.plugin;

import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.util.CallingBundleResolver;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

public class AlertTriggerResolver {

    private final CallingBundleResolver callingBundleResolver;
    private final String systemVersion;

    public AlertTriggerResolver(@Nonnull final CallingBundleResolver callingBundleResolver, @Nonnull final String systemVersion) {
        this.callingBundleResolver = requireNonNull(callingBundleResolver, "callingBundleResolver");
        this.systemVersion = requireNonNull(systemVersion, "systemVersion");
    }

    public AlertTrigger triggerForCallingBundle(final Class clazz) {
        if (clazz == null) {
            return null;
        }
        Bundle bundle = callingBundleResolver.getCallingBundle()
                .orElseGet(() -> FrameworkUtil.getBundle(clazz));
        return triggerForBundle(clazz, bundle);
    }

    public AlertTrigger triggerForBundle(final Class clazz) {
        if (clazz == null) {
            return null;
        }
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        return triggerForBundle(clazz, bundle);
    }

    private AlertTrigger triggerForBundle(final Class clazz, final Bundle bundle) {
        AlertTrigger.Builder builder = new AlertTrigger.Builder()
                .module(clazz.getName());

        if (bundle != null && bundle.getBundleId() != 0) {
            builder.plugin(OsgiHeaderUtil.getPluginKey(bundle), bundle.getVersion().toString());
        } else {
            builder.plugin("System", systemVersion);
        }

        return builder.build();
    }
}
