package com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.directory;

import com.atlassian.diagnostics.internal.platform.analytics.directory.LowDirectorySpaceEventFactory;
import com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.OperatingSystemMonitor;
import com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.OperatingSystemMonitorConfiguration;
import com.atlassian.diagnostics.internal.platform.poller.DiagnosticPoller;
import com.atlassian.event.api.EventPublisher;

import javax.annotation.Nonnull;

public class DirectorySpacePoller extends DiagnosticPoller<OperatingSystemMonitorConfiguration> {

    private final OperatingSystemMonitor operatingSystemMonitor;
    private final EventPublisher eventPublisher;
    private final Directory directory;
    private final DirectorySpaceInformationProvider directorySpaceInformationProvider;
    private final LowDirectorySpaceEventFactory lowDirectorySpaceEventFactory;

    public DirectorySpacePoller(@Nonnull final String key,
                                @Nonnull final OperatingSystemMonitor operatingSystemMonitor,
                                @Nonnull final OperatingSystemMonitorConfiguration operatingSystemMonitorConfiguration,
                                @Nonnull final EventPublisher eventPublisher,
                                @Nonnull final Directory directory,
                                @Nonnull final DirectorySpaceInformationProvider directorySpaceInformationProvider,
                                @Nonnull final LowDirectorySpaceEventFactory lowDirectorySpaceEventFactory) {
        super(key, operatingSystemMonitorConfiguration);
        this.operatingSystemMonitor = operatingSystemMonitor;
        this.eventPublisher = eventPublisher;
        this.directory = directory;
        this.directorySpaceInformationProvider = directorySpaceInformationProvider;
        this.lowDirectorySpaceEventFactory = lowDirectorySpaceEventFactory;
    }

    @Override
    protected void execute() {
        final long freeSpace = directorySpaceInformationProvider.freeSpace();
        final long minimumMegabytesOfFreeSpace = monitorConfiguration.directoryMinimumMegabytesOfFreeDiskSpace();
        if (freeSpace < 0) {
            operatingSystemMonitor.alertFileSystemInaccessible(directory.getFile());
        } else if (freeSpace < minimumMegabytesOfFreeSpace) {
            final long totalSpace = directorySpaceInformationProvider.totalSpace();
            operatingSystemMonitor.alertLowFreeDiskSpace(directory.getFile(), freeSpace, totalSpace, minimumMegabytesOfFreeSpace);

            if (lowDirectorySpaceEventFactory.isEnabled()) {
                eventPublisher.publish(lowDirectorySpaceEventFactory.create(directory.getType(), freeSpace, totalSpace, minimumMegabytesOfFreeSpace));
            }
        }
    }
}
