package com.atlassian.diagnostics.internal.platform.monitor.operatingsystem;

import com.atlassian.diagnostics.MonitorConfiguration;
import com.atlassian.diagnostics.internal.platform.poller.ScheduleInterval;

import javax.annotation.Nonnull;
import java.time.Duration;

public interface OperatingSystemMonitorConfiguration extends MonitorConfiguration {

    /**
     * @return the threshold percentage for detecting high cpu usage
     */
    double getCpuUsagePercentageThreshold();

    /**
     * @return the max amount of time that the cpu usage is above cpu usage threshold before we raise a high cpu usage alert
     */
    @Nonnull
    Duration getMaximumHighCpuUsageTime();

    /**
     * @return Minimum free disk space for directories
     */
    long directoryMinimumMegabytesOfFreeDiskSpace();

    /**
     * @return Minimum megabytes of ram
     */
    long minimumMegabytesOfRam();

    ScheduleInterval cpuPerformancePollerScheduleInterval();

    ScheduleInterval fileDirectoryPollerScheduleInterval();

    ScheduleInterval ramPollerScheduleInterval();
}
