package com.atlassian.diagnostics.internal.platform.monitor.gc;

import com.atlassian.diagnostics.MonitorConfiguration;
import com.atlassian.diagnostics.internal.platform.poller.ScheduleInterval;

import java.lang.management.GarbageCollectorMXBean;
import java.time.Duration;

public interface GarbageCollectionMonitorConfiguration extends MonitorConfiguration {

    /**
     * @return the threshold - percentage of the time taken by Old Generation garbage collection since last poll - that has to be exceeded to fire a warning-level alert
     */
    double getWarningThreshold();

    /**
     * @return the threshold - percentage of the time taken by Old Generation garbage collection since last poll - that has to be exceeded to fire an error-level alert
     */
    double getErrorThreshold();

    /**
     * @return the garbage collection poller scheduler interval - controls the interval of storing the consecutive
     * GC statistics reads.
     */
    ScheduleInterval garbageCollectionPollerScheduleInterval();

    /**
     * This ensures that the percentage of time spent on GC is calculated over longer period of time, which averages
     * single spikes and makes sure alerts are raised only when high GC load persists.
     * Setting it to e.g. 15 minutes means that current read from {@link GarbageCollectorMXBean#getCollectionTime()}
     * will be compared to a read that happened at least 15 minutes ago.
     *
     * @return the size of the sliding window that the Garbage Collection statistics are calculated in.
     */
    Duration slidingWindowSize();

    /**
     * @return whether information about threads that allocate the most memory should be included in alert details.
     * This data may be useful in troubleshooting issues but harvesting it requires stopping the JVM which may affect
     * application's performance.
     */
    boolean shouldIncludeTopThreadMemoryAllocationsInDetails();
}
