package com.atlassian.diagnostics.internal.platform.monitor;

import javax.annotation.Nonnull;
import java.time.Duration;

public class DurationUtils {

    private final Duration duration;

    private DurationUtils(@Nonnull final Duration duration) {
        this.duration = duration;
    }

    public static DurationUtils durationOfMillis(@Nonnull final long duration) {
        return durationOf(Duration.ofMillis(duration));
    }

    public static DurationUtils durationOf(@Nonnull final Duration duration) {
        return new DurationUtils(duration);
    }

    public boolean isGreaterThan(@Nonnull final Duration otherDuration) {
        return duration.compareTo(otherDuration) > 0;
    }

    public boolean isGreaterThanOrEqualTo(@Nonnull final Duration otherDuration) {
        return duration.compareTo(otherDuration) >= 0;
    }

    public boolean isSameAs(@Nonnull final Duration otherDuration) {
        return duration.compareTo(otherDuration) == 0;
    }

    public boolean isLessThan(@Nonnull final Duration otherDuration) {
        return duration.compareTo(otherDuration) < 0;
    }

    public boolean isLessThanOrEqualTo(@Nonnull final Duration otherDuration) {
        return duration.compareTo(otherDuration) <= 0;
    }
}