package com.atlassian.diagnostics.internal.platform.plugin;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import java.util.Collection;

@ReturnValuesAreNonnullByDefault
@ParametersAreNonnullByDefault
public interface PluginFinder {

    Collection<String> getPluginNamesInCurrentCallStack();

    Collection<String> getPluginNamesFromStackTrace(final StackTraceElement[] stackTrace);

    @Nullable
    default String getInvokingPluginKeyFromStackTrace(@Nullable final StackTraceElement[] stackTrace) {
        return null;
    }

    @Nullable
    default String getInvokingPluginKeyFromClassContext(@Nullable final Class<?>[] classContext) {
        return null;
    }
}
