package com.atlassian.diagnostics.internal.platform.analytics.directory;

import com.atlassian.diagnostics.internal.platform.analytics.EventFactory;
import com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.directory.DirectoryType;

import javax.annotation.Nonnull;

public abstract class LowDirectorySpaceEventFactory implements EventFactory {

    public LowDirectoryDiskSpaceAnalyticsEvent create(@Nonnull final DirectoryType folderType,
                                                      @Nonnull final Long freeDiskSpaceInMb,
                                                      @Nonnull final Long totalDiskSizeInMb,
                                                      @Nonnull final Long minDiskSizeThresholdInMb) {
        return new LowDirectoryDiskSpaceAnalyticsEvent(folderType, freeDiskSpaceInMb, totalDiskSizeInMb, minDiskSizeThresholdInMb);
    }

    public static LowDirectorySpaceEventFactory defaultFactory() {
        return new LowDirectorySpaceEventFactory() {
            @Override
            public LowDirectoryDiskSpaceAnalyticsEvent create(@Nonnull final DirectoryType folderType,
                                                              @Nonnull final Long freeDiskSpaceInMb,
                                                              @Nonnull final Long totalDiskSizeInMb,
                                                              @Nonnull final Long minDiskSizeThresholdInMb) {
                return super.create(folderType, freeDiskSpaceInMb, totalDiskSizeInMb, minDiskSizeThresholdInMb);
            }
        };
    }
}
