/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.platform.plugin;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.diagnostics.internal.platform.plugin.BundleFinder;
import com.atlassian.diagnostics.internal.platform.plugin.PluginFinder;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.atlassian.fugue.Pair;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginFinderImpl
implements PluginFinder {
    private static final Logger logger = LoggerFactory.getLogger(PluginFinderImpl.class);
    private final ClassContextSecurityManager securityManger;
    private final BundleContext bundleContext;
    private final BundleFinder bundleFinder;
    private final Cache<Class<?>, String> classPluginSourceCache;
    private final Cache<String, Class<?>> classNameClassSourceCache;

    public PluginFinderImpl(BundleContext bundleContext, BundleFinder bundleFinder) {
        this(PluginFinderImpl.createClassContextSecurityManager(), bundleContext, bundleFinder, CacheBuilder.newBuilder().maximumSize(10000L).weakKeys().expireAfterAccess(Duration.ofHours(1L)).build(), CacheBuilder.newBuilder().maximumSize(10000L).weakValues().expireAfterAccess(Duration.ofHours(1L)).build());
    }

    private static ClassContextSecurityManager createClassContextSecurityManager() {
        try {
            return new ClassContextSecurityManager();
        }
        catch (Exception e) {
            logger.debug("Failed to create security manager", (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    PluginFinderImpl(ClassContextSecurityManager securityManger, BundleContext bundleContext, BundleFinder bundleFinder, Cache<Class<?>, String> classPluginSourceCache, Cache<String, Class<?>> classNameClassSourceCache) {
        this.securityManger = securityManger;
        this.bundleContext = bundleContext;
        this.bundleFinder = bundleFinder;
        this.classPluginSourceCache = classPluginSourceCache;
        this.classNameClassSourceCache = classNameClassSourceCache;
    }

    @Override
    public Collection<String> getPluginNamesInCurrentCallStack() {
        try {
            if (this.securityManger != null) {
                return this.getPluginsFromClasses(this.securityManger.getClassContext());
            }
        }
        catch (Exception e) {
            logger.debug("Failed to get plugins list from call stack", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getPluginNamesFromStackTrace(@Nonnull StackTraceElement[] stackTrace) {
        return this.getPluginsFromClasses(this.resolveClassesFromStackTrace(stackTrace));
    }

    private Class<?>[] resolveClassesFromStackTrace(@Nonnull StackTraceElement[] stackTrace) {
        HashSet classes = new HashSet();
        for (StackTraceElement stackTraceElement : stackTrace) {
            Class cachedClass = (Class)this.classNameClassSourceCache.getIfPresent((Object)stackTraceElement.getClassName());
            if (cachedClass != null) {
                classes.add(cachedClass);
                continue;
            }
            Class<?> classFromName = this.resolveClass(stackTraceElement.getClassName());
            if (classFromName == null) continue;
            this.classNameClassSourceCache.put((Object)stackTraceElement.getClassName(), classFromName);
            classes.add(classFromName);
        }
        return classes.toArray(new Class[0]);
    }

    private Class<?> resolveClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException | LinkageError e) {
            Map<Bundle, Class> bundlesWithClass = Arrays.stream(this.bundleContext.getBundles()).filter(bundle -> bundle.getState() == 32).filter(bundle -> bundle.getHeaders().get("Atlassian-Plugin-Key") != null).map(bundle -> {
                try {
                    return new Pair(bundle, (Object)bundle.loadClass(className));
                }
                catch (ClassNotFoundException | LinkageError ex) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::left, Pair::right));
            if (bundlesWithClass.size() == 1) {
                return bundlesWithClass.entrySet().iterator().next().getValue();
            }
            if (bundlesWithClass.size() > 1) {
                logger.debug("Couldn't resolve class name [{}] as it was found in {} bundles: {}", new Object[]{className, bundlesWithClass.size(), bundlesWithClass.keySet()});
            }
            return null;
        }
    }

    private Collection<String> getPluginsFromClasses(Class<?>[] classes) {
        HashSet<String> plugins = new HashSet<String>();
        for (Class<?> clazz : classes) {
            String cachedPluginSource = (String)this.classPluginSourceCache.getIfPresent(clazz);
            if (cachedPluginSource == null) {
                this.resolvePlugin(clazz).ifPresent(pluginName -> this.add((Set<String>)plugins, (String)pluginName));
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)cachedPluginSource)) continue;
            this.add(plugins, cachedPluginSource);
        }
        return plugins;
    }

    private Optional<String> resolvePlugin(Class<?> clazz) {
        Optional<String> pluginName = this.bundleFinder.getBundleNameForClass(clazz);
        this.classPluginSourceCache.put(clazz, (Object)pluginName.orElse(""));
        return pluginName;
    }

    private void add(Set<String> plugins, String pluginName) {
        plugins.add(pluginName);
    }

    static class ClassContextSecurityManager
    extends SecurityManager {
        private static final Class<?>[] EMPTY_ARRAY = new Class[0];

        ClassContextSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            Class<?>[] classContext = super.getClassContext();
            return classContext == null ? EMPTY_ARRAY : classContext;
        }
    }
}

