package com.atlassian.diagnostics.internal.platform.poller;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class ScheduleInterval {
    private final int delay;
    private final TimeUnit timeUnit;

    public static ScheduleInterval of(final int delay, final TimeUnit timeUnit) {
        return new ScheduleInterval(delay, timeUnit);
    }

    private ScheduleInterval(final int delay, final TimeUnit timeUnit) {
        this.delay = delay;
        this.timeUnit = timeUnit;
    }

    public int getDelay() {
        return delay;
    }

    public TimeUnit getTimeUnit() {
        return timeUnit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ScheduleInterval that = (ScheduleInterval) o;
        return delay == that.delay &&
                timeUnit == that.timeUnit;
    }

    @Override
    public int hashCode() {
        return Objects.hash(delay, timeUnit);
    }
}
