package com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.cpu;

import com.atlassian.diagnostics.internal.jmx.JmxService;

class CPUDiagnostic {

    private static final String OPERATING_SYSTEM_OBJECT_NAME = "java.lang:type=OperatingSystem";
    private static final String SYSTEM_CPU_LOAD_ATTRIBUTE_NAME = "SystemCpuLoad";

    private final JmxService jmxService;

    CPUDiagnostic(final JmxService jmxService) {
        this.jmxService = jmxService;
    }

    double getSystemCpuLoad() {
        final Double systemCpuLoad = jmxService.getJmxAttribute(OPERATING_SYSTEM_OBJECT_NAME, SYSTEM_CPU_LOAD_ATTRIBUTE_NAME);
        if (systemCpuLoad != null && systemCpuLoad > 0D) {
            return systemCpuLoad * 100D;
        } else {
            return 0D;
        }
    }
}
