/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.platform.plugin;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.diagnostics.internal.platform.plugin.BundleFinder;
import com.atlassian.diagnostics.internal.platform.plugin.PluginFinder;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginFinderImpl
implements PluginFinder {
    private static final Logger logger = LoggerFactory.getLogger(PluginFinderImpl.class);
    private final ClassContextSecurityManager securityManger;
    private final BundleFinder bundleFinder;
    private final Cache<Class<?>, String> classPluginSourceCache;

    public PluginFinderImpl(BundleFinder bundleFinder) {
        this(PluginFinderImpl.createClassContextSecurityManager(), bundleFinder, CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(Duration.ofHours(1L)).build());
    }

    private static ClassContextSecurityManager createClassContextSecurityManager() {
        try {
            return new ClassContextSecurityManager();
        }
        catch (Exception e) {
            logger.debug("Failed to create security manager", (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    PluginFinderImpl(ClassContextSecurityManager securityManger, BundleFinder bundleFinder, Cache<Class<?>, String> classPluginSourceCache) {
        this.securityManger = securityManger;
        this.bundleFinder = bundleFinder;
        this.classPluginSourceCache = classPluginSourceCache;
    }

    @Override
    public Collection<String> getPluginNamesInCurrentCallStack() {
        try {
            HashSet<String> plugins = new HashSet<String>();
            if (this.securityManger != null) {
                for (Class<?> clazz : this.securityManger.getClassContext()) {
                    Optional<Object> cachedPluginSource = Optional.ofNullable(this.classPluginSourceCache.getIfPresent(clazz));
                    if (!cachedPluginSource.isPresent()) {
                        this.resolvePlugin(clazz).ifPresent(pluginName -> this.add((Set<String>)plugins, (String)pluginName));
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)cachedPluginSource.get()))) continue;
                    this.add(plugins, (String)cachedPluginSource.get());
                }
            }
            return plugins;
        }
        catch (Exception e) {
            logger.debug("Failed to get plugins list from call stack", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Optional<String> resolvePlugin(Class<?> clazz) {
        Optional<String> pluginName = this.bundleFinder.getBundleNameForClass(clazz);
        this.classPluginSourceCache.put(clazz, (Object)pluginName.orElse(""));
        return pluginName;
    }

    private void add(Set<String> plugins, String pluginName) {
        plugins.add(pluginName);
    }

    static class ClassContextSecurityManager
    extends SecurityManager {
        private static final Class<?>[] EMPTY_ARRAY = new Class[0];

        ClassContextSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            Class<?>[] classContext = super.getClassContext();
            return classContext == null ? EMPTY_ARRAY : classContext;
        }
    }
}

