package com.atlassian.diagnostics.internal.platform.poller;

import java.util.Objects;

/**
 * Snapshot of running {@link DiagnosticPoller}
 */
public class PollerInfo {
    private final String key;
    private final boolean running;

    public PollerInfo(String key, boolean running) {
        this.key = key;
        this.running = running;
    }

    public String getKey() {
        return key;
    }

    public boolean isRunning() {
        return running;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PollerInfo that = (PollerInfo) o;
        return running == that.running &&
                Objects.equals(key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, running);
    }
}
