package com.atlassian.diagnostics.internal.platform.plugin;

import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nonnull;
import java.util.Optional;

public class OsgiBundleFinder implements BundleFinder {
    private static final Logger logger = LoggerFactory.getLogger(OsgiBundleFinder.class);

    public Optional<String> getBundleNameForClass(@Nonnull final Class<?> clazz) {
        final long startTime = System.currentTimeMillis();
        try {
            return Optional.ofNullable(FrameworkUtil.getBundle(clazz))
                    .map(OsgiHeaderUtil::getPluginKey);
        } catch (Exception e) {
            logger.debug("Failed to get a bundle for class [" + clazz + "]", e);
            return Optional.empty();
        } finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Time taken in milliseconds to get bundle for class {}: {}", clazz.getName(), System.currentTimeMillis() - startTime);
            }
        }
    }

}
