package com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.cpu;

import javax.annotation.Nonnull;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import java.lang.management.ManagementFactory;

public class CPUDiagnostic {

    private static final String OPERATING_SYSTEM = "java.lang:type=OperatingSystem";

    double getCpuUsage() {
        try {
            final Object systemCpuUsageAttributeValue = ManagementFactory
                    .getPlatformMBeanServer()
                    .getAttribute(getOperatingSystemObjectName(), "SystemCpuLoad");
            if (systemCpuUsageAttributeValue == null) {
                return 0;
            } else {
                return (double) systemCpuUsageAttributeValue >= 0D ? (double) systemCpuUsageAttributeValue * 100 : 0;
            }
        } catch (final JMException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Nonnull
    private ObjectName getOperatingSystemObjectName() throws MalformedObjectNameException {
        return new ObjectName(OPERATING_SYSTEM);
    }
}
