package com.atlassian.diagnostics.internal.platform.monitor.db.pool.resolver;

import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.Query;
import java.lang.management.ManagementFactory;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;

public class JmxDatabasePoolBeanResolver {

    private Optional<JmxDatabasePoolBean> jmxDatabasePoolBean = Optional.empty();

    public Optional<JmxDatabasePoolBean> getDatabaseConnectionPool() {
        if (!jmxDatabasePoolBean.isPresent()) {
            jmxDatabasePoolBean = EnumSet.allOf(JmxDatabasePoolAttributes.class).stream()
                    .map(jmx -> getDbPoolJmxInfo(ManagementFactory.getPlatformMBeanServer(), jmx))
                    .filter(Optional::isPresent)
                    .findAny()
                    .orElse(Optional.empty());
        }

        return jmxDatabasePoolBean;
    }

    private Optional<JmxDatabasePoolBean> getDbPoolJmxInfo(final MBeanServer beanServer, final JmxDatabasePoolAttributes jmx) {
        final Set<ObjectInstance> jmxObjectInstances = beanServer.queryMBeans(null, Query.isInstanceOf(Query.value(jmx.instanceOfQuery)));
        if (jmxObjectInstances.isEmpty()) {
            return Optional.empty();
        } else {
            return Optional.of(new JmxDatabasePoolBean(jmx, jmxObjectInstances.iterator().next()));
        }
    }
}
