package com.atlassian.diagnostics.ipd.api.registry;

import com.atlassian.diagnostics.ipd.api.MeterConfigurations;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.meters.CounterMeter;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter.MBeanSupplier;
import com.atlassian.diagnostics.ipd.api.meters.JmxCopyMeter;
import com.atlassian.diagnostics.ipd.api.meters.StatsMeter;
import com.atlassian.diagnostics.ipd.api.meters.ValueMeter;

import javax.management.ObjectName;

/**
 * A no-op implementation of {@link IpdRegistry}. This implementation does not record any metrics in JMX or log files.
 * @since 5.0.0
 */
public class NoopIpdRegistry extends AbstractIpdMeterRegistry {

    public NoopIpdRegistry(final MeterConfigurations meterConfigurations) {
        super(meterConfigurations);
    }

    /**
     * Creates a new instance of {@link NoopIpdRegistry} with all meters disabled by default.
     */
    public NoopIpdRegistry() {
        super(MeterConfigurations.create(b -> b.addEnabledCheck(m -> false)));
    }

    @Override
    public ValueMeter value(final String name, final MeterTag... tags) {
        return register(ValueMeter.NOOP_FACTORY, name, tags);
    }

    @Override
    public StatsMeter stats(final String name, final MeterTag... tags) {
        return register(StatsMeter.NOOP_FACTORY, name, tags);
    }

    @Override
    public CounterMeter counter(final String name, final MeterTag... tags) {
        return register(CounterMeter.NOOP_FACTORY, name, tags);
    }

    @Override
    public <T> CustomMeter<T> custom(final String name, final Class<T> type, final MeterTag... tags) {
        return custom(name, new MBeanSupplier<>(type), tags);
    }

    @Override
    public <T> CustomMeter<T> custom(final String name, final MBeanSupplier<T> mBeanSupplier, final MeterTag... tags) {
        return register(CustomMeter.noopFactory(mBeanSupplier), name, tags);
    }

    @Override
    public JmxCopyMeter statsCopy(final String name, final ObjectName objectToCopy, final MeterTag... tags) {
        return register(JmxCopyMeter.NOOP_FACTORY, name, tags);
    }

    @Override
    public void unregisterAllDisabledMetrics() {
    }
}
