package com.atlassian.diagnostics.ipd.api.meters.custom.type;

import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

/**
 * Metric type holding information about the connection state and total number of failures set.
 * Made for use with {@link CustomMeter}.
 * @since 5.0.0
 */
public class IpdConnectionState implements IpdConnectionStateMxBean {
    private final AtomicBoolean connected = new AtomicBoolean(true);
    private final AtomicLong totalFailures = new AtomicLong(0);

    public void setConnected(boolean connected) {
        this.connected.set(connected);
        if (!connected) {
            totalFailures.incrementAndGet();
        }
    }

    @Override
    public boolean isConnected() {
        return connected.get();
    }

    @Override
    public long getTotalFailures() {
        return totalFailures.get();
    }
}
