package com.atlassian.diagnostics.ipd.api.meters.config;

import com.atlassian.diagnostics.ipd.api.meters.IpdMeter;

import java.util.function.Function;

/**
 * Factory for creating {@link IpdMeter} instances.
 * @param <T> the implementation of {@link IpdMeter} that this factory creates
 * @since 5.0.0
 */
public final class MeterFactory<T extends IpdMeter> {

    private final Function<MeterConfig, T> factory;
    private final String typeId;
    private final String typeSuffix;

    /**
     *
     * @param factory Function that creates a new instance of the meter for a given {@link MeterConfig}
     * @param typeId the typeId of the meter is a string value unique to the type of the meter, should be the same for compatible meters
     * @param typeSuffix the suffix of the type of the meter. This suffix is added at the end of the meter name when it is registered.
     */
    public MeterFactory(final Function<MeterConfig, T> factory,
                        final String typeId,
                        final String typeSuffix) {
        this.factory = factory;
        this.typeId = typeId;
        this.typeSuffix = typeSuffix;
    }

    public T createMetric(MeterConfig config) {
        return factory.apply(config);
    }

    public String typeSuffix() {
        return typeSuffix;
    }

    public String getTypeId() {
        return typeId;
    }
}
