package com.atlassian.diagnostics.ipd.api.meters;

import java.util.concurrent.TimeUnit;

/**
 * Wraps {@link ValueMeter} and {@link StatsMeter} into one class allowing updating both of them in one operation.
 * @since 3.0.0
 */
public class ValueAndStatsMeterWrapper {

    private final ValueMeter ipdValueMetric;
    private final StatsMeter ipdStatsMetric;

    public ValueAndStatsMeterWrapper(final StatsMeter ipdStatsMetric, final ValueMeter ipdValueMetric) {
        this.ipdValueMetric = ipdValueMetric;
        this.ipdStatsMetric = ipdStatsMetric;
    }


    public void update(Long value) {
        ipdStatsMetric.update(value);
        ipdValueMetric.update(value);
    }


    public void updateValue(Long value) {
        ipdValueMetric.update(value);
    }


    public void updateStats(Long value) {
        ipdStatsMetric.update(value);
    }

    public void updateStats(Long value, TimeUnit timeUnit) {
        ipdStatsMetric.update(value, timeUnit);
    }
}

