package com.atlassian.diagnostics.ipd.api.meters;

import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;

/**
 * Interface representing a JMX copy meter, which is a type of {@link IpdMeter}.
 * The meter copies attributes from existing JMX MBean and republishes them in JMX and log file through the IPD framework.
 * <p>
 * All attribute changes in the original metric will be reflected in JMX and log file after calling {@link JmxCopyMeter#update()}.
 * </p>
 */
public interface JmxCopyMeter extends IpdMeter {
    String TYPE_ID = "jmx-copy";
    MeterFactory<JmxCopyMeter> NOOP_FACTORY = new MeterFactory<>(Noop::new, TYPE_ID, "");

    /**
     * Synchronizes the meter state with the original JMX MBean.
     * <p>If the original MBean is not available, this meter will also be unregistered from JMX.</p>
     * <p>If the original MBean just got registered in JMX, after the update call this meter will also be registered.</p>
     */
    void update();

    @Override
    default String getTypeId() {
        return TYPE_ID;
    }

    class Noop extends NoopMeter implements JmxCopyMeter {
        protected Noop(final MeterConfig meterConfig) {
            super(meterConfig);
        }

        @Override
        public void update() {
            metricUpdated();
        }
    }
}
