package com.atlassian.diagnostics.ipd.api.jobs;

import java.util.Objects;

/**
 * @since 5.0.0
 */
public class IpdJobRegistration {
    private final IpdJob ipdJob;
    private final String key;
    private final boolean workInProgress;

    private IpdJobRegistration(IpdJobRegistrationBuilder builder) {
        this.ipdJob = builder.ipdJob;
        this.key = builder.key;
        this.workInProgress = builder.workInProgress;
    }

    public String getKey() {
        return key;
    }

    public IpdJob getIpdJob() {
        return ipdJob;
    }

    public boolean isWorkInProgress() {
        return workInProgress;
    }

    /**
     * Creates a new IpdJobRegistrationBuilder.
     * @param ipdJob the job to register
     * @param key unique key for the job, should be dot-separated string e.g. <b>database.connection.latency</b>
     * @return a new IpdJobRegistrationBuilder
     */
    public static IpdJobRegistrationBuilder builder(IpdJob ipdJob, String key) {
        return new IpdJobRegistrationBuilder(ipdJob, key);
    }

    public static class IpdJobRegistrationBuilder {
        private final IpdJob ipdJob;
        private final String key;
        private boolean workInProgress = false;

        public IpdJobRegistrationBuilder(IpdJob ipdJob, String key) {
            this.ipdJob = ipdJob;
            this.key = key;
        }

        public IpdJobRegistrationBuilder setWorkInProgress() {
            this.workInProgress = true;
            return this;
        }

        public IpdJobRegistration build() {
            return new IpdJobRegistration(this);
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final IpdJobRegistration that = (IpdJobRegistration) o;
        return Objects.equals(ipdJob, that.ipdJob);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(ipdJob);
    }
}
