package com.atlassian.diagnostics.ipd.api;

import com.atlassian.diagnostics.ipd.api.meters.IpdMeter;

import java.time.Instant;

/**
 * Service for logging IPD metrics.
 * @since 2.2.0
 */
public interface IpdLoggingService {

    /**
     * Logs the given meter with the current timestamp. <br/>
     * Meter value is logged only if its configuration allows it.
     * That is, if the meter is enabled, visible in JMX and the logging condition is met.
     * @param meter the meter to log
     */
    void logMetric(IpdMeter meter);

    /**
     * Logs the given meter with a the provided timestamp. Useful for logging manny meters with exactly the same timestamp. <br/>
     * Meter value is logged only if its configuration allows it.
     * That is, if the meter is enabled, visible in JMX and the logging condition is met.
     * @param meter the meter to log
     */
    void logMetric(IpdMeter meter, Instant timestamp);

    /**
     * Logs the given meter with a the provided timestamp. Useful for logging manny meters with exactly the same timestamp. <br/>
     * Meter is unconditionally logged, regardless of its configuration.
     * @param meter the meter to log
     * @since 5.0.0
     */
    void forceLogMetric(IpdMeter meter, Instant timestamp);
}
