package com.atlassian.diagnostics.ipd.api;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Cached state of the In Product Diagnostics feature flags.
 * The product should implement this class and update the state of the feature flags in regular intervals.
 * @since 5.0.0
 */
public abstract class CachedIpdState {
    protected final AtomicBoolean isIpdFeatureFlagEnabled = new AtomicBoolean(true);
    protected final AtomicBoolean isWipIpdFeatureFlagEnabled = new AtomicBoolean(false);
    protected final AtomicBoolean isIpdExtraLoggingEnabled = new AtomicBoolean(false);

    public boolean isIpdEnabled() {
        return isIpdFeatureFlagEnabled.get();
    }

    public boolean isWipIpdEnabled() {
        return isWipIpdFeatureFlagEnabled.get();
    }

    public boolean isIpdExtraLoggingEnabled() {
        return isIpdExtraLoggingEnabled.get();
    }

    /**
     * Refresh the state of the feature flags.
     * <p><b>Implementation details</b><br/>
     * Implementation of this method should update the state of feature flags used by IPD.
     * See variables {@link #isIpdFeatureFlagEnabled}, {@link #isWipIpdFeatureFlagEnabled}, {@link #isIpdExtraLoggingEnabled}
     * </p>
     * <p>For correct IPD state make sure the product is invoking this method in regular interval.</p>
     */
    public abstract void refreshState();
}