package com.atlassian.diagnostics;

import javax.annotation.Nonnull;

/**
 * An issue that can be detected by a {@link ComponentMonitor} and for which an {@link Alert alert} can be raised
 */
public interface Issue {

    /**
     * @return the component to which the issue applies
     */
    @Nonnull
    Component getComponent();

    /**
     * @return a (internationalized) description of the issue
     */
    @Nonnull
    String getDescription();

    /**
     * @return the unique ID of the issue, which corresponds to the {@link Component#getId component ID} followed by
     *         the numeric issue ID used when the issue was {@link ComponentMonitor#defineIssue(int) defined}
     *         (e.g {@code EVENT-01234}
     */
    @Nonnull
    String getId();

    /**
     * @return helper class used to marshal the {@link Alert#getDetails() alert details} for the issue to JSON and
     *         back
     */
    @Nonnull
    <T> JsonMapper<T> getJsonMapper();

    /**
     * @return the issue's severity
     */
    @Nonnull
    Severity getSeverity();

    /**
     * @return a (internationalized) short summary of the issue
     */
    @Nonnull
    String getSummary();
}
