package com.atlassian.diagnostics.ipd.internal.spi;

import com.atlassian.util.profiling.MetricKey;

import javax.management.ObjectName;
import java.util.List;

/**
 * IPD metric with a unique MetricKey.
 *
 * @since 3.0.0
 */
public interface IpdMetric {

    /**
     * @return MetricKey that identifies metric by name and tag values
     */
    MetricKey getMetricKey();

    /**
     * @return MetricOptions that the metric was constructed with
     */
    MetricOptions getOptions();

    /**
     * ObjectName of the MBean. Can be used to query this metric value in JMX.
     * @return ObjectName of this metric
     */
    ObjectName getObjectName();

    /**
     *
     * @return true if metric is enabled, false otherwise
     */
    boolean isEnabled();

    /**
     * Reads current values of the metric. The values will be returned regardless of metric enabled state.
     *
     * @param extraAttributes if true the values will contain all possible attributes,
     *                        otherwise the values will contain only the most important attributes
     * @return List of IpdMetricValue. <b>Empty list</b> when returning values for metric is not possible.
     */
    List<IpdMetricValue> readValues(boolean extraAttributes);

    /**
     * Unregisters metric from JMX interface. The metric enabled state stays unchanged.
     * This method should skip unregistering when the metric is not registered.
     */
    void unregisterJmx();

    /**
     * Unregisters metric from JMX and permanently disables metric instance.
     */
    void close();
}
