package com.atlassian.diagnostics;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Helper used to convert {@link Alert#getDetails() alert details} to and from JSON. The framework provides a
 * standard implementation based on the Jackson framework. Custom helpers can be provided when
 * {@link ComponentMonitor#defineIssue(int) defining new issues} if the details need custom conversion.
 */
public interface JsonMapper<T> {

    /**
     * @return the type of the {@link Alert#getDetails() alert details}
     */
    @Nonnull
    Class<T> getType();

    /**
     * Parses the provided JSON and returns an instance of the provided type, or {@code null} if parsing failed
     *
     * @param json the JSON string to parse
     * @return the parsed instance, or {@code null} if {@code json} was blank or parsing failed
     */
    @Nullable
    T parseJson(@Nullable String json);

    /**
     * Creates a JSON representation of the provided value
     *
     * @param value the value
     * @return the JSON representation of the provided value, or {@code null} if {@code value} was {@code null} or
     *          conversion to JSON failed.
     */
    @Nullable
    String toJson(@Nullable T value);
}
