package com.atlassian.diagnostics;

import javax.annotation.Nonnull;
import java.time.Instant;
import java.util.Optional;

/**
 * Represent an alert {@link ComponentMonitor#alert raised} by one of the {@link ComponentMonitor component monitors}
 * to signal that an {@link Issue issue} has been detected by the monitor.
 */
public interface Alert {

    /**
     * @return the alert details, if any was created for the alert in question
     */
    @Nonnull
    Optional<Object> getDetails();

    /**
     * @return the alert's ID
     */
    long getId();

    /**
     * @return the issue for which the alert was created
     */
    @Nonnull
    Issue getIssue();

    /**
     * @return the name of the node that triggered the alert
     */
    @Nonnull
    String getNodeName();

    /**
     * @return the timestamp that describes when the alert was created
     */
    @Nonnull
    Instant getTimestamp();

    /**
     * @return the trigger of the reported {@link #getIssue issue}
     */
    @Nonnull
    AlertTrigger getTrigger();
}
