package com.atlassian.diagnostics.util;

import com.atlassian.plugin.osgi.hostcomponents.CallingBundleAccessor;
import com.google.common.annotations.VisibleForTesting;
import org.eclipse.gemini.blueprint.service.importer.support.LocalBundleContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nonnull;
import java.util.Optional;

import static java.util.Optional.ofNullable;

/**
 * Retrieves the OSGI bundle or plugin that's calling into the current code path from OSGI.
 */
public class CallingBundleResolver {

    private static final Logger log = LoggerFactory.getLogger(CallingBundleResolver.class);

    private final boolean geminiSupported;

    @VisibleForTesting
    CallingBundleResolver(boolean geminiSupported) {
        this.geminiSupported = geminiSupported;
    }

    public CallingBundleResolver() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.eclipse.gemini.blueprint.service.importer.support.LocalBundleContext");
        } catch (Exception e) {
            log.debug("OSGI Gemini Blueprints are not available. Capability to determine calling " +
                    "OSGI bundle will be limited.");
        }
        geminiSupported = clazz != null;
    }

    /**
     * @return the calling plugin, or {@link Optional#empty()} if not currently called from a plugin
     */
    @Nonnull
    public Optional<Bundle> getCallingBundle() {
        Bundle bundle = null;
        if (geminiSupported) {
            BundleContext bundleContext = LocalBundleContext.getInvokerBundleContext();
            if (bundleContext != null) {
                bundle = bundleContext.getBundle();
            }
        }
        if (bundle == null) {
            bundle = CallingBundleAccessor.getCallingBundle();
        }
        return ofNullable(bundle);
    }
}
