package com.atlassian.diagnostics;

import com.google.common.base.MoreObjects;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

import static com.atlassian.diagnostics.DiagnosticsConstants.PLUGIN_NOT_DETECTED_KEY;
import static com.google.common.base.MoreObjects.firstNonNull;

public class PluginDetails {

    private final String key;
    private final String name;
    private final String version;

    public PluginDetails(String key, String name, String version) {
        this.key = MoreObjects.firstNonNull(StringUtils.trimToNull(key), PLUGIN_NOT_DETECTED_KEY);
        this.name = firstNonNull(name, key);
        this.version = version;
    }

    public String getKey() {
        return key;
    }

    public String getName() {
        return name;
    }

    public String getVersion() {
        return version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PluginDetails that = (PluginDetails) o;
        return Objects.equals(key, that.key) &&
                Objects.equals(version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, version);
    }
}
