package com.atlassian.diagnostics.detail;

import javax.annotation.Nonnull;
import java.util.List;
import java.util.Set;

/**
 * Produces thread dumps with a string representations of stack traces for the supplied threads. If the stack trace
 * of a thread is unavailable (per the contract of {@link Thread#getStackTrace()}), the {@link ThreadDump} is created
 * with an empty stack
 */
public interface ThreadDumpProducer {

    /**
     * Produces {@link ThreadDump thread dumps} for the supplied threads
     *
     * @param threads the threads to generate stack traces for
     * @return thread dumps for each of the provided threads
     */
    @Nonnull
    List<ThreadDump> produce(@Nonnull Set<Thread> threads);
}
