/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devrel.servlet;

import com.atlassian.devrel.plugin.PlatformComponents;
import com.atlassian.devrel.servlet.RequiresAdminServlet;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HomepageServlet
extends RequiresAdminServlet {
    private static final String HOMEPAGE_TEMPLATE = "/templates/homepage.vm";
    private static final String I18N_AVAILABLE_KEY = "i18nAvailable";
    private static final String I18N_STATE_KEY = "i18nActive";
    private static final String SDK_VERSION_KEY = "sdkVersion";
    private static final String SPACE_CONTEXT_KEY = "space";
    private static final String SPEAKEASY_AVAILABLE_KEY = "speakeasyAvailable";
    private static final String ACTIVEOBJECTS_AVAILABLE_KEY = "aoAvailable";
    private static final String PLUGIN_DATA_EDITOR_AVAILABLE_KEY = "pdeAvailable";
    private static final String SYSTEM_INFO_LINK_KEY = "systemInfoLink";
    private static final String PLATFORM_COMPONENTS_KEY = "platformComponents";
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final PlatformComponents platformComponents;

    public HomepageServlet(UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider, ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, PlatformComponents platformComponents) {
        super(userManager, renderer, loginUriProvider);
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
        this.platformComponents = platformComponents;
    }

    @Override
    public Map<String, Object> getContext(HttpServletRequest req) {
        HashMap context = Maps.newHashMap();
        context.put(I18N_AVAILABLE_KEY, this.isI18nTranslationAvailable());
        if (this.isI18nTranslationAvailable()) {
            context.put(I18N_STATE_KEY, this.getI18nState(req));
        }
        context.put(SDK_VERSION_KEY, this.getSdkVersion());
        context.put(SPACE_CONTEXT_KEY, this.getSpaceNameForProduct());
        context.put(SPEAKEASY_AVAILABLE_KEY, this.isSpeakeasyAvailable());
        context.put(ACTIVEOBJECTS_AVAILABLE_KEY, this.isActiveObjectsAvailable());
        context.put(PLUGIN_DATA_EDITOR_AVAILABLE_KEY, this.isPluginDataEditorAvailable());
        context.put(SYSTEM_INFO_LINK_KEY, this.getSystemInfoLink());
        context.put(PLATFORM_COMPONENTS_KEY, this.platformComponents.getPlatformComponents());
        return context;
    }

    @Override
    public String getTemplatePath() {
        return HOMEPAGE_TEMPLATE;
    }

    private boolean isI18nTranslationAvailable() {
        return this.getAppName().equals("jira") || this.getAppName().equals("confluence");
    }

    private boolean getI18nState(HttpServletRequest req) {
        Object o;
        String appName = this.getAppName();
        HttpSession session = req.getSession(false);
        if (appName.equals("jira")) {
            return session.getAttribute("com.atlassian.jira.util.i18n.I18nTranslationModeSwitch") != null;
        }
        if (appName.equals("confluence") && (o = session.getAttribute("confluence.i18n.mode")) != null) {
            return o.getClass().getSimpleName().equals("LightningTranslationMode");
        }
        return false;
    }

    private String getSpaceNameForProduct() {
        String appName = this.getAppName();
        if (appName.equals("fisheye") || appName.equals("crucible")) {
            return "FECRUDEV";
        }
        if (appName.equalsIgnoreCase("confluence")) {
            return "CONFDEV";
        }
        return appName.toUpperCase() + "DEV";
    }

    private String getSdkVersion() {
        return System.getProperty("atlassian.sdk.version", "3.7 or earlier");
    }

    private boolean isSpeakeasyAvailable() {
        return this.pluginAccessor.getEnabledPlugin("com.atlassian.labs.speakeasy-plugin") != null;
    }

    private boolean isActiveObjectsAvailable() {
        return this.pluginAccessor.getEnabledPlugin("com.atlassian.activeobjects.activeobjects-plugin") != null;
    }

    private boolean isPluginDataEditorAvailable() {
        return this.pluginAccessor.getEnabledPlugin("com.atlassian.plugins.plugin-data-editor") != null;
    }

    private String getSystemInfoLink() {
        String url = "";
        String appName = this.getAppName();
        if (appName.equals("jira")) {
            url = "/secure/admin/ViewSystemInfo.jspa";
        } else if (appName.equals("confluence") || appName.equals("bamboo")) {
            url = "/admin/systeminfo.action";
        } else if (appName.equals("fisheye") || appName.equals("crucible")) {
            url = "/admin/sysinfo.do";
        } else if (appName.equals("crowd")) {
            // empty if block
        }
        return url;
    }

    private String getAppName() {
        return this.applicationProperties.getDisplayName().toLowerCase();
    }
}

