/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas.pullrequest;

import com.atlassian.devops.schemas.UserReference;
import com.atlassian.devops.schemas.jackson.InstantToIso861Deserializer;
import com.atlassian.devops.schemas.jackson.InstantToIso861Serializer;
import com.atlassian.devops.schemas.pullrequest.BranchReference;
import com.atlassian.devops.schemas.pullrequest.ImmutablePullRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URL;
import java.time.Instant;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutablePullRequest.class)
@JsonDeserialize(as=ImmutablePullRequest.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Value.Immutable
@Value.Style(stagedBuilder=true)
public interface PullRequest {
    @JsonProperty
    public String id();

    @JsonProperty
    public String title();

    @JsonProperty
    public URL url();

    @JsonProperty
    public State state();

    @JsonProperty
    @JsonSerialize(using=InstantToIso861Serializer.class)
    @JsonDeserialize(using=InstantToIso861Deserializer.class)
    public Instant updatedDate();

    @JsonProperty
    public int commentCount();

    @JsonProperty
    public BranchReference sourceBranch();

    @JsonProperty
    public BranchReference destinationBranch();

    @JsonProperty
    @JsonSerialize(using=InstantToIso861Serializer.class)
    @JsonDeserialize(using=InstantToIso861Deserializer.class)
    @Nullable
    public Instant createdDate();

    @JsonProperty
    @Nullable
    public UserReference author();

    public static enum State {
        OPEN,
        MERGED,
        DECLINED;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static State fromJson(String value) {
            for (State state : State.values()) {
                if (!state.name().equalsIgnoreCase(value)) continue;
                return state;
            }
            return null;
        }
    }
}

