/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas.pullrequest;

import com.atlassian.devops.schemas.pullrequest.BranchReference;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URL;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BranchReference", generator="Immutables")
@Immutable
public final class ImmutableBranchReference
implements BranchReference {
    @Nullable
    private final String name;
    @Nullable
    private final URL url;

    private ImmutableBranchReference(@Nullable String name, @Nullable URL url) {
        this.name = name;
        this.url = url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public URL url() {
        return this.url;
    }

    public final ImmutableBranchReference withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableBranchReference(value, this.url);
    }

    public final ImmutableBranchReference withUrl(@Nullable URL value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableBranchReference(this.name, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBranchReference && this.equalTo((ImmutableBranchReference)another);
    }

    private boolean equalTo(ImmutableBranchReference another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.url, another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.url);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BranchReference").omitNullValues().add("name", (Object)this.name).add("url", (Object)this.url).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBranchReference fromJson(Json json) {
        Builder builder = ImmutableBranchReference.builder();
        if (json.nameIsSet) {
            builder.name(json.name);
        }
        if (json.urlIsSet) {
            builder.url(json.url);
        }
        return builder.build();
    }

    public static ImmutableBranchReference copyOf(BranchReference instance) {
        if (instance instanceof ImmutableBranchReference) {
            return (ImmutableBranchReference)instance;
        }
        return ImmutableBranchReference.builder().name(instance.name()).url(instance.url()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BranchReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_NAME = 1L;
        private static final long OPT_BIT_URL = 2L;
        private long optBits;
        @Nullable
        private String name;
        @Nullable
        private URL url;

        private Builder() {
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            Builder.checkNotIsSet(this.nameIsSet(), "name");
            this.name = name;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URL url) {
            Builder.checkNotIsSet(this.urlIsSet(), "url");
            this.url = url;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableBranchReference build() {
            return new ImmutableBranchReference(this.name, this.url);
        }

        private boolean nameIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean urlIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of BranchReference is strict, attribute is already set: ".concat(name));
            }
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BranchReference", generator="Immutables")
    static final class Json
    implements BranchReference {
        @Nullable
        String name;
        boolean nameIsSet;
        @Nullable
        URL url;
        boolean urlIsSet;

        Json() {
        }

        @JsonProperty
        public void setName(@Nullable String name) {
            this.name = name;
            this.nameIsSet = true;
        }

        @JsonProperty
        public void setUrl(@Nullable URL url) {
            this.url = url;
            this.urlIsSet = true;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URL url() {
            throw new UnsupportedOperationException();
        }
    }
}

