/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas;

import com.atlassian.devops.schemas.TrackingReference;
import com.atlassian.devops.schemas.jackson.InstantToIso861Deserializer;
import com.atlassian.devops.schemas.jackson.InstantToIso861Serializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TrackingReference", generator="Immutables")
@Immutable
public final class ImmutableTrackingReference
implements TrackingReference {
    private final String traceId;
    private final Instant timestamp;

    private ImmutableTrackingReference(String traceId, Instant timestamp) {
        this.traceId = traceId;
        this.timestamp = timestamp;
    }

    @Override
    @JsonProperty
    public String traceId() {
        return this.traceId;
    }

    @Override
    @JsonProperty
    @JsonSerialize(using=InstantToIso861Serializer.class)
    @JsonDeserialize(using=InstantToIso861Deserializer.class)
    public Instant timestamp() {
        return this.timestamp;
    }

    public final ImmutableTrackingReference withTraceId(String value) {
        String newValue = Objects.requireNonNull(value, "traceId");
        if (this.traceId.equals(newValue)) {
            return this;
        }
        return new ImmutableTrackingReference(newValue, this.timestamp);
    }

    public final ImmutableTrackingReference withTimestamp(Instant value) {
        if (this.timestamp == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "timestamp");
        return new ImmutableTrackingReference(this.traceId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTrackingReference && this.equalTo((ImmutableTrackingReference)another);
    }

    private boolean equalTo(ImmutableTrackingReference another) {
        return this.traceId.equals(another.traceId) && this.timestamp.equals(another.timestamp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.traceId.hashCode();
        h += (h << 5) + this.timestamp.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TrackingReference").omitNullValues().add("traceId", (Object)this.traceId).add("timestamp", (Object)this.timestamp).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTrackingReference fromJson(Json json) {
        Builder builder = (Builder)ImmutableTrackingReference.builder();
        if (json.traceId != null) {
            builder.traceId(json.traceId);
        }
        if (json.timestamp != null) {
            builder.timestamp(json.timestamp);
        }
        return builder.build();
    }

    public static ImmutableTrackingReference copyOf(TrackingReference instance) {
        if (instance instanceof ImmutableTrackingReference) {
            return (ImmutableTrackingReference)instance;
        }
        return ((Builder)ImmutableTrackingReference.builder()).traceId(instance.traceId()).timestamp(instance.timestamp()).build();
    }

    public static TraceIdBuildStage builder() {
        return new Builder();
    }

    @Generated(from="TrackingReference", generator="Immutables")
    public static interface BuildFinal {
        public ImmutableTrackingReference build();
    }

    @Generated(from="TrackingReference", generator="Immutables")
    public static interface TimestampBuildStage {
        public BuildFinal timestamp(Instant var1);
    }

    @Generated(from="TrackingReference", generator="Immutables")
    public static interface TraceIdBuildStage {
        public TimestampBuildStage traceId(String var1);
    }

    @Generated(from="TrackingReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements TraceIdBuildStage,
    TimestampBuildStage,
    BuildFinal {
        private static final long INIT_BIT_TRACE_ID = 1L;
        private static final long INIT_BIT_TIMESTAMP = 2L;
        private long initBits = 3L;
        @Nullable
        private String traceId;
        @Nullable
        private Instant timestamp;

        private Builder() {
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder traceId(String traceId) {
            Builder.checkNotIsSet(this.traceIdIsSet(), "traceId");
            this.traceId = Objects.requireNonNull(traceId, "traceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty
        @JsonSerialize(using=InstantToIso861Serializer.class)
        @JsonDeserialize(using=InstantToIso861Deserializer.class)
        @CanIgnoreReturnValue
        public final Builder timestamp(Instant timestamp) {
            Builder.checkNotIsSet(this.timestampIsSet(), "timestamp");
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableTrackingReference build() {
            this.checkRequiredAttributes();
            return new ImmutableTrackingReference(this.traceId, this.timestamp);
        }

        private boolean traceIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean timestampIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of TrackingReference is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.traceIdIsSet()) {
                attributes.add("traceId");
            }
            if (!this.timestampIsSet()) {
                attributes.add("timestamp");
            }
            return "Cannot build TrackingReference, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TrackingReference", generator="Immutables")
    static final class Json
    implements TrackingReference {
        @Nullable
        String traceId;
        @Nullable
        Instant timestamp;

        Json() {
        }

        @JsonProperty
        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @JsonProperty
        @JsonSerialize(using=InstantToIso861Serializer.class)
        @JsonDeserialize(using=InstantToIso861Deserializer.class)
        public void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public String traceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant timestamp() {
            throw new UnsupportedOperationException();
        }
    }
}

