/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas;

import com.atlassian.devops.schemas.TenantReference;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TenantReference", generator="Immutables")
@Immutable
public final class ImmutableTenantReference
implements TenantReference {
    private final String cloudId;
    private final String activationId;

    private ImmutableTenantReference(String cloudId, String activationId) {
        this.cloudId = cloudId;
        this.activationId = activationId;
    }

    @Override
    @JsonProperty
    public String cloudId() {
        return this.cloudId;
    }

    @Override
    @JsonProperty
    public String activationId() {
        return this.activationId;
    }

    public final ImmutableTenantReference withCloudId(String value) {
        String newValue = Objects.requireNonNull(value, "cloudId");
        if (this.cloudId.equals(newValue)) {
            return this;
        }
        return new ImmutableTenantReference(newValue, this.activationId);
    }

    public final ImmutableTenantReference withActivationId(String value) {
        String newValue = Objects.requireNonNull(value, "activationId");
        if (this.activationId.equals(newValue)) {
            return this;
        }
        return new ImmutableTenantReference(this.cloudId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTenantReference && this.equalTo((ImmutableTenantReference)another);
    }

    private boolean equalTo(ImmutableTenantReference another) {
        return this.cloudId.equals(another.cloudId) && this.activationId.equals(another.activationId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.cloudId.hashCode();
        h += (h << 5) + this.activationId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TenantReference").omitNullValues().add("cloudId", (Object)this.cloudId).add("activationId", (Object)this.activationId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTenantReference fromJson(Json json) {
        Builder builder = (Builder)ImmutableTenantReference.builder();
        if (json.cloudId != null) {
            builder.cloudId(json.cloudId);
        }
        if (json.activationId != null) {
            builder.activationId(json.activationId);
        }
        return builder.build();
    }

    public static ImmutableTenantReference copyOf(TenantReference instance) {
        if (instance instanceof ImmutableTenantReference) {
            return (ImmutableTenantReference)instance;
        }
        return ((Builder)ImmutableTenantReference.builder()).cloudId(instance.cloudId()).activationId(instance.activationId()).build();
    }

    public static CloudIdBuildStage builder() {
        return new Builder();
    }

    @Generated(from="TenantReference", generator="Immutables")
    public static interface BuildFinal {
        public ImmutableTenantReference build();
    }

    @Generated(from="TenantReference", generator="Immutables")
    public static interface ActivationIdBuildStage {
        public BuildFinal activationId(String var1);
    }

    @Generated(from="TenantReference", generator="Immutables")
    public static interface CloudIdBuildStage {
        public ActivationIdBuildStage cloudId(String var1);
    }

    @Generated(from="TenantReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements CloudIdBuildStage,
    ActivationIdBuildStage,
    BuildFinal {
        private static final long INIT_BIT_CLOUD_ID = 1L;
        private static final long INIT_BIT_ACTIVATION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String cloudId;
        @Nullable
        private String activationId;

        private Builder() {
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder cloudId(String cloudId) {
            Builder.checkNotIsSet(this.cloudIdIsSet(), "cloudId");
            this.cloudId = Objects.requireNonNull(cloudId, "cloudId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder activationId(String activationId) {
            Builder.checkNotIsSet(this.activationIdIsSet(), "activationId");
            this.activationId = Objects.requireNonNull(activationId, "activationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableTenantReference build() {
            this.checkRequiredAttributes();
            return new ImmutableTenantReference(this.cloudId, this.activationId);
        }

        private boolean cloudIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean activationIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of TenantReference is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.cloudIdIsSet()) {
                attributes.add("cloudId");
            }
            if (!this.activationIdIsSet()) {
                attributes.add("activationId");
            }
            return "Cannot build TenantReference, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TenantReference", generator="Immutables")
    static final class Json
    implements TenantReference {
        @Nullable
        String cloudId;
        @Nullable
        String activationId;

        Json() {
        }

        @JsonProperty
        public void setCloudId(String cloudId) {
            this.cloudId = cloudId;
        }

        @JsonProperty
        public void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        @Override
        public String cloudId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String activationId() {
            throw new UnsupportedOperationException();
        }
    }
}

