/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas;

import com.atlassian.devops.schemas.IssueAssociation;
import com.atlassian.devops.schemas.IssueAssociationType;
import com.atlassian.devops.schemas.TenantReference;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IssueAssociation", generator="Immutables")
@Immutable
public final class ImmutableIssueAssociation
implements IssueAssociation {
    private final IssueAssociationType type;
    private final String id;
    private final String ari;
    private final TenantReference tenant;

    private ImmutableIssueAssociation(IssueAssociationType type, String id, String ari, TenantReference tenant) {
        this.type = type;
        this.id = id;
        this.ari = ari;
        this.tenant = tenant;
    }

    @Override
    @JsonProperty
    public IssueAssociationType type() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String ari() {
        return this.ari;
    }

    @Override
    @JsonProperty
    public TenantReference tenant() {
        return this.tenant;
    }

    public final ImmutableIssueAssociation withType(IssueAssociationType value) {
        if (this.type == value) {
            return this;
        }
        IssueAssociationType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableIssueAssociation(newValue, this.id, this.ari, this.tenant);
    }

    public final ImmutableIssueAssociation withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableIssueAssociation(this.type, newValue, this.ari, this.tenant);
    }

    public final ImmutableIssueAssociation withAri(String value) {
        String newValue = Objects.requireNonNull(value, "ari");
        if (this.ari.equals(newValue)) {
            return this;
        }
        return new ImmutableIssueAssociation(this.type, this.id, newValue, this.tenant);
    }

    public final ImmutableIssueAssociation withTenant(TenantReference value) {
        if (this.tenant == value) {
            return this;
        }
        TenantReference newValue = Objects.requireNonNull(value, "tenant");
        return new ImmutableIssueAssociation(this.type, this.id, this.ari, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIssueAssociation && this.equalTo((ImmutableIssueAssociation)another);
    }

    private boolean equalTo(ImmutableIssueAssociation another) {
        return this.type.equals((Object)another.type) && this.id.equals(another.id) && this.ari.equals(another.ari) && this.tenant.equals(another.tenant);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.ari.hashCode();
        h += (h << 5) + this.tenant.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IssueAssociation").omitNullValues().add("type", (Object)this.type).add("id", (Object)this.id).add("ari", (Object)this.ari).add("tenant", (Object)this.tenant).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIssueAssociation fromJson(Json json) {
        Builder builder = (Builder)ImmutableIssueAssociation.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.ari != null) {
            builder.ari(json.ari);
        }
        if (json.tenant != null) {
            builder.tenant(json.tenant);
        }
        return builder.build();
    }

    public static ImmutableIssueAssociation copyOf(IssueAssociation instance) {
        if (instance instanceof ImmutableIssueAssociation) {
            return (ImmutableIssueAssociation)instance;
        }
        return ((Builder)ImmutableIssueAssociation.builder()).type(instance.type()).id(instance.id()).ari(instance.ari()).tenant(instance.tenant()).build();
    }

    public static TypeBuildStage builder() {
        return new Builder();
    }

    @Generated(from="IssueAssociation", generator="Immutables")
    public static interface BuildFinal {
        public ImmutableIssueAssociation build();
    }

    @Generated(from="IssueAssociation", generator="Immutables")
    public static interface TenantBuildStage {
        public BuildFinal tenant(TenantReference var1);
    }

    @Generated(from="IssueAssociation", generator="Immutables")
    public static interface AriBuildStage {
        public TenantBuildStage ari(String var1);
    }

    @Generated(from="IssueAssociation", generator="Immutables")
    public static interface IdBuildStage {
        public AriBuildStage id(String var1);
    }

    @Generated(from="IssueAssociation", generator="Immutables")
    public static interface TypeBuildStage {
        public IdBuildStage type(IssueAssociationType var1);
    }

    @Generated(from="IssueAssociation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements TypeBuildStage,
    IdBuildStage,
    AriBuildStage,
    TenantBuildStage,
    BuildFinal {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_ARI = 4L;
        private static final long INIT_BIT_TENANT = 8L;
        private long initBits = 15L;
        @Nullable
        private IssueAssociationType type;
        @Nullable
        private String id;
        @Nullable
        private String ari;
        @Nullable
        private TenantReference tenant;

        private Builder() {
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder type(IssueAssociationType type) {
            Builder.checkNotIsSet(this.typeIsSet(), "type");
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            Builder.checkNotIsSet(this.idIsSet(), "id");
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder ari(String ari) {
            Builder.checkNotIsSet(this.ariIsSet(), "ari");
            this.ari = Objects.requireNonNull(ari, "ari");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder tenant(TenantReference tenant) {
            Builder.checkNotIsSet(this.tenantIsSet(), "tenant");
            this.tenant = Objects.requireNonNull(tenant, "tenant");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        public ImmutableIssueAssociation build() {
            this.checkRequiredAttributes();
            return new ImmutableIssueAssociation(this.type, this.id, this.ari, this.tenant);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean idIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean ariIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean tenantIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of IssueAssociation is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.ariIsSet()) {
                attributes.add("ari");
            }
            if (!this.tenantIsSet()) {
                attributes.add("tenant");
            }
            return "Cannot build IssueAssociation, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IssueAssociation", generator="Immutables")
    static final class Json
    implements IssueAssociation {
        @Nullable
        IssueAssociationType type;
        @Nullable
        String id;
        @Nullable
        String ari;
        @Nullable
        TenantReference tenant;

        Json() {
        }

        @JsonProperty
        public void setType(IssueAssociationType type) {
            this.type = type;
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setAri(String ari) {
            this.ari = ari;
        }

        @JsonProperty
        public void setTenant(TenantReference tenant) {
            this.tenant = tenant;
        }

        @Override
        public IssueAssociationType type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ari() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TenantReference tenant() {
            throw new UnsupportedOperationException();
        }
    }
}

