/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas;

import com.atlassian.devops.schemas.Branch;
import com.atlassian.devops.schemas.BranchCreated;
import com.atlassian.devops.schemas.EntityAssociation;
import com.atlassian.devops.schemas.Payloadable;
import com.atlassian.devops.schemas.ProviderReference;
import com.atlassian.devops.schemas.RepositoryReference;
import com.atlassian.devops.schemas.TrackingReference;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BranchCreated", generator="Immutables")
@Immutable
public final class ImmutableBranchCreated
implements BranchCreated {
    @Nullable
    private final TrackingReference tracking;
    private final transient String metaType;
    private final transient String metaSchemaAri;
    private final EntityAssociation associations;
    @Nullable
    private final ProviderReference provider;
    private final RepositoryReference repository;
    private final Branch branch;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBranchCreated(@Nullable TrackingReference tracking, EntityAssociation associations, @Nullable ProviderReference provider, RepositoryReference repository, Branch branch) {
        this.tracking = tracking;
        this.associations = associations;
        this.provider = provider;
        this.repository = repository;
        this.branch = branch;
        this.metaType = this.initShim.metaType();
        this.metaSchemaAri = this.initShim.metaSchemaAri();
        this.initShim = null;
    }

    private String metaTypeInitialize() {
        return BranchCreated.super.metaType();
    }

    private String metaSchemaAriInitialize() {
        return BranchCreated.super.metaSchemaAri();
    }

    @Override
    @JsonProperty
    @Nullable
    public TrackingReference tracking() {
        return this.tracking;
    }

    @Override
    @JsonProperty(value="metaType")
    public String metaType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.metaType() : this.metaType;
    }

    @Override
    @JsonProperty(value="metaSchemaAri")
    public String metaSchemaAri() {
        InitShim shim = this.initShim;
        return shim != null ? shim.metaSchemaAri() : this.metaSchemaAri;
    }

    @Override
    @JsonProperty
    public EntityAssociation associations() {
        return this.associations;
    }

    @Override
    @JsonProperty
    @Nullable
    public ProviderReference provider() {
        return this.provider;
    }

    @Override
    @JsonProperty
    public RepositoryReference repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    public Branch branch() {
        return this.branch;
    }

    public final ImmutableBranchCreated withTracking(@Nullable TrackingReference value) {
        if (this.tracking == value) {
            return this;
        }
        return new ImmutableBranchCreated(value, this.associations, this.provider, this.repository, this.branch);
    }

    public final ImmutableBranchCreated withAssociations(EntityAssociation value) {
        if (this.associations == value) {
            return this;
        }
        EntityAssociation newValue = Objects.requireNonNull(value, "associations");
        return new ImmutableBranchCreated(this.tracking, newValue, this.provider, this.repository, this.branch);
    }

    public final ImmutableBranchCreated withProvider(@Nullable ProviderReference value) {
        if (this.provider == value) {
            return this;
        }
        return new ImmutableBranchCreated(this.tracking, this.associations, value, this.repository, this.branch);
    }

    public final ImmutableBranchCreated withRepository(RepositoryReference value) {
        if (this.repository == value) {
            return this;
        }
        RepositoryReference newValue = Objects.requireNonNull(value, "repository");
        return new ImmutableBranchCreated(this.tracking, this.associations, this.provider, newValue, this.branch);
    }

    public final ImmutableBranchCreated withBranch(Branch value) {
        if (this.branch == value) {
            return this;
        }
        Branch newValue = Objects.requireNonNull(value, "branch");
        return new ImmutableBranchCreated(this.tracking, this.associations, this.provider, this.repository, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBranchCreated && this.equalTo((ImmutableBranchCreated)another);
    }

    private boolean equalTo(ImmutableBranchCreated another) {
        return Objects.equals(this.tracking, another.tracking) && this.metaType.equals(another.metaType) && this.metaSchemaAri.equals(another.metaSchemaAri) && this.associations.equals(another.associations) && Objects.equals(this.provider, another.provider) && this.repository.equals(another.repository) && this.branch.equals(another.branch);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tracking);
        h += (h << 5) + this.metaType.hashCode();
        h += (h << 5) + this.metaSchemaAri.hashCode();
        h += (h << 5) + this.associations.hashCode();
        h += (h << 5) + Objects.hashCode(this.provider);
        h += (h << 5) + this.repository.hashCode();
        h += (h << 5) + this.branch.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BranchCreated").omitNullValues().add("tracking", (Object)this.tracking).add("metaType", (Object)this.metaType).add("metaSchemaAri", (Object)this.metaSchemaAri).add("associations", (Object)this.associations).add("provider", (Object)this.provider).add("repository", (Object)this.repository).add("branch", (Object)this.branch).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBranchCreated fromJson(Json json) {
        Builder builder = ImmutableBranchCreated.builder();
        if (json.tracking != null) {
            builder.tracking(json.tracking);
        }
        if (json.associations != null) {
            builder.associations(json.associations);
        }
        if (json.provider != null) {
            builder.provider(json.provider);
        }
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.branch != null) {
            builder.branch(json.branch);
        }
        return builder.build();
    }

    public static ImmutableBranchCreated copyOf(BranchCreated instance) {
        if (instance instanceof ImmutableBranchCreated) {
            return (ImmutableBranchCreated)instance;
        }
        return ImmutableBranchCreated.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BranchCreated", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ASSOCIATIONS = 1L;
        private static final long INIT_BIT_REPOSITORY = 2L;
        private static final long INIT_BIT_BRANCH = 4L;
        private long initBits = 7L;
        @Nullable
        private TrackingReference tracking;
        @Nullable
        private EntityAssociation associations;
        @Nullable
        private ProviderReference provider;
        @Nullable
        private RepositoryReference repository;
        @Nullable
        private Branch branch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BranchCreated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Payloadable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TrackingReference trackingValue;
            Payloadable instance;
            if (object instanceof BranchCreated) {
                instance = (BranchCreated)object;
                this.associations(instance.associations());
                this.repository(instance.repository());
                ProviderReference providerValue = instance.provider();
                if (providerValue != null) {
                    this.provider(providerValue);
                }
                this.branch(instance.branch());
            }
            if (object instanceof Payloadable && (trackingValue = (instance = (Payloadable)object).tracking()) != null) {
                this.tracking(trackingValue);
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder tracking(@Nullable TrackingReference tracking) {
            this.tracking = tracking;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder associations(EntityAssociation associations) {
            this.associations = Objects.requireNonNull(associations, "associations");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder provider(@Nullable ProviderReference provider) {
            this.provider = provider;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(RepositoryReference repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder branch(Branch branch) {
            this.branch = Objects.requireNonNull(branch, "branch");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableBranchCreated build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBranchCreated(this.tracking, this.associations, this.provider, this.repository, this.branch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("associations");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("repository");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("branch");
            }
            return "Cannot build BranchCreated, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BranchCreated", generator="Immutables")
    static final class Json
    implements BranchCreated {
        @Nullable
        TrackingReference tracking;
        @Nullable
        EntityAssociation associations;
        @Nullable
        ProviderReference provider;
        @Nullable
        RepositoryReference repository;
        @Nullable
        Branch branch;

        Json() {
        }

        @JsonProperty
        public void setTracking(@Nullable TrackingReference tracking) {
            this.tracking = tracking;
        }

        @JsonProperty
        public void setAssociations(EntityAssociation associations) {
            this.associations = associations;
        }

        @JsonProperty
        public void setProvider(@Nullable ProviderReference provider) {
            this.provider = provider;
        }

        @JsonProperty
        public void setRepository(RepositoryReference repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setBranch(Branch branch) {
            this.branch = branch;
        }

        @Override
        public TrackingReference tracking() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String metaType() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String metaSchemaAri() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EntityAssociation associations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProviderReference provider() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RepositoryReference repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Branch branch() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="BranchCreated", generator="Immutables")
    private final class InitShim {
        private byte metaTypeBuildStage = 0;
        private String metaType;
        private byte metaSchemaAriBuildStage = 0;
        private String metaSchemaAri;

        private InitShim() {
        }

        String metaType() {
            if (this.metaTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metaTypeBuildStage == 0) {
                this.metaTypeBuildStage = (byte)-1;
                this.metaType = Objects.requireNonNull(ImmutableBranchCreated.this.metaTypeInitialize(), "metaType");
                this.metaTypeBuildStage = 1;
            }
            return this.metaType;
        }

        String metaSchemaAri() {
            if (this.metaSchemaAriBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metaSchemaAriBuildStage == 0) {
                this.metaSchemaAriBuildStage = (byte)-1;
                this.metaSchemaAri = Objects.requireNonNull(ImmutableBranchCreated.this.metaSchemaAriInitialize(), "metaSchemaAri");
                this.metaSchemaAriBuildStage = 1;
            }
            return this.metaSchemaAri;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.metaTypeBuildStage == -1) {
                attributes.add("metaType");
            }
            if (this.metaSchemaAriBuildStage == -1) {
                attributes.add("metaSchemaAri");
            }
            return "Cannot build BranchCreated, attribute initializers form cycle " + attributes;
        }
    }
}

