/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas;

import com.atlassian.devops.schemas.Branch;
import com.atlassian.devops.schemas.jackson.InstantToIso861Deserializer;
import com.atlassian.devops.schemas.jackson.InstantToIso861Serializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Branch", generator="Immutables")
@Immutable
public final class ImmutableBranch
implements Branch {
    private final String name;
    private final URL url;
    private final Instant lastCommitTimestamp;

    private ImmutableBranch(String name, URL url, Instant lastCommitTimestamp) {
        this.name = name;
        this.url = url;
        this.lastCommitTimestamp = lastCommitTimestamp;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public URL url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @JsonSerialize(using=InstantToIso861Serializer.class)
    @JsonDeserialize(using=InstantToIso861Deserializer.class)
    public Instant lastCommitTimestamp() {
        return this.lastCommitTimestamp;
    }

    public final ImmutableBranch withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableBranch(newValue, this.url, this.lastCommitTimestamp);
    }

    public final ImmutableBranch withUrl(URL value) {
        if (this.url == value) {
            return this;
        }
        URL newValue = Objects.requireNonNull(value, "url");
        return new ImmutableBranch(this.name, newValue, this.lastCommitTimestamp);
    }

    public final ImmutableBranch withLastCommitTimestamp(Instant value) {
        if (this.lastCommitTimestamp == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "lastCommitTimestamp");
        return new ImmutableBranch(this.name, this.url, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBranch && this.equalTo((ImmutableBranch)another);
    }

    private boolean equalTo(ImmutableBranch another) {
        return this.name.equals(another.name) && this.url.equals(another.url) && this.lastCommitTimestamp.equals(another.lastCommitTimestamp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.lastCommitTimestamp.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Branch").omitNullValues().add("name", (Object)this.name).add("url", (Object)this.url).add("lastCommitTimestamp", (Object)this.lastCommitTimestamp).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBranch fromJson(Json json) {
        Builder builder = (Builder)ImmutableBranch.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.lastCommitTimestamp != null) {
            builder.lastCommitTimestamp(json.lastCommitTimestamp);
        }
        return builder.build();
    }

    public static ImmutableBranch copyOf(Branch instance) {
        if (instance instanceof ImmutableBranch) {
            return (ImmutableBranch)instance;
        }
        return ((Builder)ImmutableBranch.builder()).name(instance.name()).url(instance.url()).lastCommitTimestamp(instance.lastCommitTimestamp()).build();
    }

    public static NameBuildStage builder() {
        return new Builder();
    }

    @Generated(from="Branch", generator="Immutables")
    public static interface BuildFinal {
        public ImmutableBranch build();
    }

    @Generated(from="Branch", generator="Immutables")
    public static interface LastCommitTimestampBuildStage {
        public BuildFinal lastCommitTimestamp(Instant var1);
    }

    @Generated(from="Branch", generator="Immutables")
    public static interface UrlBuildStage {
        public LastCommitTimestampBuildStage url(URL var1);
    }

    @Generated(from="Branch", generator="Immutables")
    public static interface NameBuildStage {
        public UrlBuildStage name(String var1);
    }

    @Generated(from="Branch", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements NameBuildStage,
    UrlBuildStage,
    LastCommitTimestampBuildStage,
    BuildFinal {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_URL = 2L;
        private static final long INIT_BIT_LAST_COMMIT_TIMESTAMP = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private URL url;
        @Nullable
        private Instant lastCommitTimestamp;

        private Builder() {
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            Builder.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(URL url) {
            Builder.checkNotIsSet(this.urlIsSet(), "url");
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty
        @JsonSerialize(using=InstantToIso861Serializer.class)
        @JsonDeserialize(using=InstantToIso861Deserializer.class)
        @CanIgnoreReturnValue
        public final Builder lastCommitTimestamp(Instant lastCommitTimestamp) {
            Builder.checkNotIsSet(this.lastCommitTimestampIsSet(), "lastCommitTimestamp");
            this.lastCommitTimestamp = Objects.requireNonNull(lastCommitTimestamp, "lastCommitTimestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public ImmutableBranch build() {
            this.checkRequiredAttributes();
            return new ImmutableBranch(this.name, this.url, this.lastCommitTimestamp);
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean urlIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean lastCommitTimestampIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Branch is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.urlIsSet()) {
                attributes.add("url");
            }
            if (!this.lastCommitTimestampIsSet()) {
                attributes.add("lastCommitTimestamp");
            }
            return "Cannot build Branch, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Branch", generator="Immutables")
    static final class Json
    implements Branch {
        @Nullable
        String name;
        @Nullable
        URL url;
        @Nullable
        Instant lastCommitTimestamp;

        Json() {
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setUrl(URL url) {
            this.url = url;
        }

        @JsonProperty
        @JsonSerialize(using=InstantToIso861Serializer.class)
        @JsonDeserialize(using=InstantToIso861Deserializer.class)
        public void setLastCommitTimestamp(Instant lastCommitTimestamp) {
            this.lastCommitTimestamp = lastCommitTimestamp;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URL url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant lastCommitTimestamp() {
            throw new UnsupportedOperationException();
        }
    }
}

