/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.db.config.password.ciphers.algorithm.serialization;

import com.atlassian.db.config.password.ciphers.algorithm.serialization.SafeObjectInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationFile {
    private static final Logger log = LoggerFactory.getLogger(SerializationFile.class);
    public static final Set<String> DESERIALIZATION_ALLOWED_CLASSES = new HashSet<String>(Arrays.asList(SealedObject.class.getCanonicalName(), SecretKeySpec.class.getCanonicalName(), SecretKey.class.getCanonicalName(), "[B"));
    private final String notEmptyFilePath;

    public SerializationFile(String notEmptyFilePath) {
        this.notEmptyFilePath = notEmptyFilePath;
    }

    public <T> void createFileAndSave(T objectToSave) {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.notEmptyFilePath));){
            objectOutputStream.writeObject(objectToSave);
            log.debug("Saved file: " + this.notEmptyFilePath);
        }
        catch (IOException e) {
            log.error("Couldn't save or create file needed for encryption/decryption. Tried to save object: {} using file path: {}", new Object[]{objectToSave, this.notEmptyFilePath, e});
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T read(Class<T> clazz) {
        try (SafeObjectInputStream objectIn = new SafeObjectInputStream(new FileInputStream(this.notEmptyFilePath), DESERIALIZATION_ALLOWED_CLASSES);){
            Object o = objectIn.readObject();
            if (!o.getClass().getCanonicalName().equals(clazz.getCanonicalName())) {
                throw new ClassCastException("Expected: " + clazz + ", got: " + o.getClass());
            }
            Object object = o;
            return (T)object;
        }
        catch (IOException e) {
            log.error("Couldn't read file needed for encryption/decryption. Tried to read file under: " + this.notEmptyFilePath, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ClassCastException e) {
            log.error("Couldn't cast object found under: " + this.notEmptyFilePath + " Make sure you are passing correct file path.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            log.error("Couldn't find class for object found under: " + this.notEmptyFilePath + " Make sure you are passing correct file path.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

