package com.atlassian.db.config.password.ciphers.algorithm.serialization;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.function.Function;

public class EnvironmentVarBasedConfiguration {

    private static final Logger log = LoggerFactory.getLogger(EnvironmentVarBasedConfiguration.class);
    private static final String ENV_VARIABLE_PREFIX = "com_atlassian_db_config_password_ciphers_algorithm_";
    private final Function<String, String> getSystemEnv;
    private final String objectClassName;

    public EnvironmentVarBasedConfiguration(final String objectClassName, final Function<String, String> getSystemEnv) {
        this.getSystemEnv = getSystemEnv;
        this.objectClassName = objectClassName;
    }

    public String getFromEnv() {
        final String envVarName = (ENV_VARIABLE_PREFIX + objectClassName).replace(".", "_");
        log.debug("Will try to read file path from environment variable under: " + envVarName);
        final String path = getSystemEnv.apply(envVarName);
        if (path == null) {
            log.debug("Nothing found under environment variable.");
        }
        return path;
    }
}
