package com.atlassian.db.config.password;

import java.util.Optional;

public interface CipherProvider {

    /**
     * xml key which can be used by products to store canonical class name
     */
    String ATLASSIAN_PASSWORD_CIPHER_PROVIDER_XML_KEY = "atlassian-password-cipher-provider";

    /**
     * @return default cipher which is already available in the class loader.
     */
    String getDefaultCipherProviderClassName();

    /**
     * Creates a new instance of {@link Cipher} every time it's called.
     * Is not caching or storing created instance.
     *
     * In case cipherProviderClassName is null or empty returns {@link Optional#empty()}
     * In case not being able to create an instance logs an error message and throws an {@link Exception}
     *
     * @param cipherProviderClassName canonical name of the {@link Class} which implements {@link Cipher} and should be initiated.
     * @return new instance of {@link Cipher} packed inside Optional or {@link Optional#empty()} in case passed param is null or empty.
     * @throws IllegalArgumentException in case of {@link ClassNotFoundException}, {@link InstantiationException} or {@link IllegalAccessException}
     */
    Optional<Cipher> getInstance(String cipherProviderClassName);
}
