package com.atlassian.data.parsers

import com.atlassian.data.ValuesWithFrequencies
import com.atlassian.data.utils.FileUtils

class CsvParser {
    companion object {
        fun parse(resourceName: String): ValuesWithFrequencies<String> {
            val valuesAndFreqs = ValuesWithFrequencies<String>()

            FileUtils.newBufferedReader(resourceName).forEachLine { line ->
                val stringAndFrequency = line.split(',')
                valuesAndFreqs.accept(stringAndFrequency[0], stringAndFrequency[1].toLong())
            }

            return valuesAndFreqs
        }
    }
}
