package com.atlassian.data.generators

import com.atlassian.data.parsers.CsvParser
import com.atlassian.data.utils.RandomUtils
import java.util.concurrent.ConcurrentHashMap

class NameGenerator {
    companion object {
        private val femaleNames = CsvParser.parse("/names/female_given_names.csv")
        private val maleNames = CsvParser.parse("/names/male_given_names.csv")
        private val lastNames = CsvParser.parse("/names/last_names.csv")
    }

    private val namesGeneratedSoFar = ConcurrentHashMap.newKeySet<String>()

    private var nonCollidingGivenNamesNumber : Int = 1

    fun pickRandomUnique(preferredGivenNames: Int = nonCollidingGivenNamesNumber): String {
        for (i in 1..10) {
            val picked = pickRandom(preferredGivenNames)
            if (namesGeneratedSoFar.add(picked)) {
                return picked
            }
        }
        if (preferredGivenNames==nonCollidingGivenNamesNumber) {
            ++nonCollidingGivenNamesNumber
        }
        return pickRandomUnique(preferredGivenNames+1)
    }

    fun pickRandom(givenNames: Int = 1): String {
        val givenName = if (RandomUtils.nextBoolean()) maleNames else femaleNames

        return (1..givenNames)
            .map { givenName.pickRandom() }
            .plus(lastNames.pickRandom())
            .map { it.capitalize() }
            .joinToString(" ")
    }
}
